if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
  tutorial_settings.played = played_in_past
end)

local left_portal = resize.location.left_portal
local right_portal = resize.location.right_portal


state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

local default_vertical = 0.3
set_default_vertical(0.3)
function tutorial_routine_first()
  return coroutine.wrap(function()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Try this factory", 0.15))
    ))
    embed(pause_until(function() return state.grid:ticks() >= 5 end))
    embed(announce("Oops! The portals fell down.", 3, 0.1))
    embed(ramp_until(function() return false end, do_all(
      announce_lambda("Try again", 0.2),
      highlight_menu_item_lambda("stop_button")
    )))
  end)
end
function pin_positions()
  local ret = {}
  for i,v in pairs(state.grid:entities()) do
    if v.type == "Pin" then
      if v.position == left_portal then
        ret.left = true
      elseif v.position == right_portal then
        ret.right = true
      end
    end
  end
  return ret
end
function draw_missing_pins_lambda()
  local ab = bouncing_arrow_at_game_lambda(Rectangle.new(left_portal), 0.06, DOWN)
  local ag = glowing_box_at_game_lambda(Rectangle.new(left_portal))

  local bb = bouncing_arrow_at_game_lambda(Rectangle.new(right_portal), 0.06, DOWN)
  local bg = glowing_box_at_game_lambda(Rectangle.new(right_portal))

  return function(c, fade)
    local pos = pin_positions()
    if not pos.left then
      ab(c, fade)
      ag(c, fade)
    end
    if not pos.right then
      bb(c, fade)
      bg(c, fade)
    end
  end
end
function is_done()
  local pins = pin_positions()
  return pins.left and pins.right
end
function is_pin_selected()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialPlacePin" then
    return true
  end
end
local function only_open_pin(i)
  return i.type == "PinAction";
end
local function only_pin_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.rmb_click then
      return true
    elseif i.event == MouseEventAction.lmb_click or i.event == MouseEventAction.lmb_double_click then
      local partial = state:get_partial_interaction()
      if partial.type == "PartialPlacePin" then
        if partial.where == left_portal or partial.where == right_portal then
          return true
        end
      end
      return false
    end
  elseif i.type == "MouseUpdateAction" then
    return i.lmb == MOUSE_NONE
  else
    return i == PlayerInteraction.cancel
  end
end
function tutorial_routine_second()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    embed(announce("Portals are static when active...", 3, 0.07, captured_cancel()))
    embed(announce("...but can move when not.", 3, 0.1, captured_cancel()))
    state:suppress_toolbar_menu(false)
    embed(pause(0.25))
    while not is_done() do
      set_user_input_filter(only_open_pin)
      embed(ramp_until(is_pin_selected, do_all(
        announce_lambda("Tool: Pin", 0.2, default_vertical + 0.15),
        announce_lambda("(Open the sliding toolbar panel to activate)", 0.06, default_vertical)
      )))
      set_user_input_filter(only_pin_interaction)
      embed(ramp_while(
        lifted_and(
          is_pin_selected,
          lifted_not(is_done)
        ),
        do_all(
          announce_lambda("Click to pin.", 0.1),
          draw_missing_pins_lambda()
        )
      ))
    end
    embed(tutorial_routine_finished())
  end)
end
function tutorial_routine_finished()
  return coroutine.wrap(function()
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_or_speed_or_cancel_filter)
    embed(ramp_while(is_pin_selected, announce_lambda("Right click to exit pin tool", 0.08)))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
  end)
end

function tutorial_routine()
  if not played_in_past then
    return tutorial_routine_first()
  elseif not is_done() then
    return tutorial_routine_second()
  else
    return tutorial_routine_finished()
  end
end

draw_interpreted_routine(tutorial_routine())

state:filter_interactions(function(i)
  if i.type == "CreatePin" or i.type == "Unpin" then
    if i.where == left_portal or i.where == right_portal then
      return
    end
  end
  return "This level only allowed interacting by adding pins to the portals.";
end)
